/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8237;

import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.AccessDenied;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class BoxInfo {
    static ResourceBundle bundle;
    public static final String PROPNAME = "BoxInfo.jdm8237.nways.ibm";
    public static final String[] deviceGifs;
    public static final int Hub8237 = 0;
    public static final int Hub8225 = 4;
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int Timeouts = 3;
    public static final int ServerProblems = 4;
    public static final int UnknownHub = 5;
    private GenModel deviceModel;
    private Hashtable modelList;
    private JdmBrowser browser;
    private Hashtable hubTypeTable = new Hashtable();
    private Hashtable hubIdTable = new Hashtable();
    private Hashtable hubSegmentTable = new Hashtable();
    private Hashtable femTypeTable = new Hashtable();
    private int deviceType;
    private int deviceStatus;
    private int deviceMaxStack;
    private int deviceMaxPorts;
    private boolean isApplication;
    private static final int RASID = 19;
    private static final int RASSUB = 29;
    boolean loggingOn = false;

    public BoxInfo(GenModel genModel, JdmBrowser jdmBrowser) {
        this.browser = jdmBrowser;
        if (RAS.isEnabled(19, 29)) {
            RAS.trace(19, 29, this, "BoxInfo", "constructor entering");
        }
        bundle = ResourceBundle.getBundle("ibm.nways.jdm8237.Resources");
        if (genModel == null) {
            this.deviceStatus = 4;
            if (RAS.isEnabled(19, 29)) {
                RAS.trace(19, 29, this, "BoxInfo", "null device model - abort processing");
            }
        } else {
            this.deviceModel = genModel;
            this.modelList = new Hashtable();
            try {
                ModelInfo modelInfo = this.deviceModel.getInfo("Initial");
                OID oID = new OID("1.3.6.1.4.1.2.3.22");
                OID oID2 = new OID("1.3.6.1.4.1.2.6.37");
                Serializable serializable = modelInfo.get("Initial.SysObjectID");
                if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) {
                    this.deviceStatus = 2;
                    if (RAS.isEnabled(19, 29)) {
                        RAS.trace(19, 29, this, "BoxInfo", "device not responding " + serializable.toString());
                    }
                    new BoxDownMsg(this.browser.getFrame(), bundle.getString("UNKNOWNJDM"));
                } else {
                    OID oID3;
                    String string = serializable.toString();
                    if (RAS.isEnabled(19, 29)) {
                        RAS.trace(19, 29, this, "BoxInfo", "sysOid = " + string);
                    }
                    if (oID.equals(oID3 = new OID(string))) {
                        this.deviceStatus = 1;
                        this.deviceType = 0;
                        this.deviceMaxStack = 10;
                        this.deviceMaxPorts = 17;
                        this.create8237StackTables();
                    } else if (oID2.equals(oID3)) {
                        this.deviceStatus = 1;
                        this.deviceType = 4;
                        this.deviceMaxStack = 6;
                        this.deviceMaxPorts = 13;
                        this.create8225StackTables();
                    } else {
                        this.deviceStatus = 5;
                    }
                }
            }
            catch (Exception exception) {
                this.deviceStatus = 4;
            }
        }
        if (RAS.isEnabled(19, 29)) {
            RAS.trace(19, 29, this, "BoxInfo", "constructor exit");
        }
    }

    public static void setInNavContext(NavigationContext navigationContext, BoxInfo boxInfo) {
        navigationContext.put((Object)PROPNAME, (Object)boxInfo);
    }

    public static BoxInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (BoxInfo)navigationContext.get((Object)PROPNAME, bl);
    }

    public JdmBrowser getHubBrowser() {
        return this.browser;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public int getDeviceMaxStack() {
        return this.deviceMaxStack;
    }

    public int getDeviceMaxPorts() {
        return this.deviceMaxPorts;
    }

    public Hashtable getHubTypeTable() {
        return this.hubTypeTable;
    }

    public Hashtable getHubIdTable() {
        return this.hubIdTable;
    }

    public Hashtable getHubSegmentTable() {
        return this.hubSegmentTable;
    }

    public Hashtable getFemTypeTable() {
        return this.femTypeTable;
    }

    private void create8237StackTables() {
        OctetString octetString = null;
        OctetString octetString2 = null;
        ModelInfo modelInfo = null;
        if (RAS.isEnabled(19, 29)) {
            RAS.trace(19, 29, this, "create8237StackTables", "entering");
        }
        if (this.deviceModel == null) {
            if (RAS.isEnabled(19, 29)) {
                RAS.trace(19, 29, this, "create8237StackTables", "null device model - abort processing");
            }
            this.deviceStatus = 4;
            return;
        }
        try {
            modelInfo = this.deviceModel.getInfo("StackData");
            octetString = (OctetString)modelInfo.get("StackData.BasicStackHealth");
            this.deviceStatus = 1;
        }
        catch (Exception exception) {
            RAS.logError(19, 29, this, "create8237StackTables", "EXCEPTION_GETTING_MODELINFO", (Object)"StackData", (Object)"Jdm8237Model");
            RAS.logException(19, 29, this, "create8237StackTables", exception);
            this.deviceStatus = 4;
        }
        int n = octetString.value.length;
        int n2 = 0;
        while (n2 < n) {
            octetString2 = new OctetString(octetString.value, n2, 24);
            int n3 = octetString2.value[21] & 0xF0;
            switch (n3 >>= 4) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    int n4 = octetString2.value[21] & 0xF;
                    switch (n4) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            this.hubIdTable.put(new Integer(n3), new Integer(n4));
                            int n5 = octetString2.value[19] & 3;
                            this.hubTypeTable.put(new Integer(n4), new Integer(n5));
                            int n6 = octetString2.value[20] & 3;
                            this.hubSegmentTable.put(new Integer(n4), new Integer(n6));
                            int n7 = octetString2.value[17] & 7;
                            this.femTypeTable.put(new Integer(n4), new Integer(n7));
                        }
                    }
                }
            }
            n2 += 24;
        }
        if (RAS.isEnabled(19, 29)) {
            RAS.trace(19, 29, this, "create8237StackTables", "leaving");
        }
    }

    private void create8225StackTables() {
        OctetString octetString = null;
        OctetString octetString2 = null;
        ModelInfo modelInfo = null;
        if (RAS.isEnabled(19, 29)) {
            RAS.trace(19, 29, this, "create8225StackTables", "entering");
        }
        if (this.deviceModel == null) {
            this.deviceStatus = 4;
            if (RAS.isEnabled(19, 29)) {
                RAS.trace(19, 29, this, "create8225StackTables", "null device model - abort processing");
            }
            return;
        }
        try {
            modelInfo = this.deviceModel.getInfo("Ibm8225StackData");
            octetString = (OctetString)modelInfo.get("Ibm8225StackData.BasicStackHealth");
            this.deviceStatus = 1;
        }
        catch (Exception exception) {
            RAS.logError(19, 29, this, "create8225StackTables", "EXCEPTION_GETTING_MODELINFO", (Object)"Ibm8225StackData", (Object)"Jdm8237Model");
            RAS.logException(19, 29, this, "create8225StackTables", exception);
            this.deviceStatus = 4;
        }
        int n = octetString.value.length;
        int n2 = 0;
        while (n2 < n) {
            octetString2 = new OctetString(octetString.value, n2, 19);
            int n3 = octetString2.value[14] & 0xE0;
            switch (n3 >>= 5) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    int n4 = octetString2.value[14] & 0x1C;
                    switch (n4 >>= 2) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            this.hubIdTable.put(new Integer(n3), new Integer(n4));
                            int n5 = octetString2.value[13] & 3;
                            this.hubTypeTable.put(new Integer(n4), new Integer(n5));
                            int n6 = octetString2.value[14] & 3;
                            this.hubSegmentTable.put(new Integer(n4), new Integer(n6));
                            int n7 = octetString2.value[12] & 0xC0;
                            n7 = (n7 >>= 6) == 0 ? 1 : (n7 == 2 ? 5 : 6);
                            this.femTypeTable.put(new Integer(n4), new Integer(n7));
                        }
                    }
                }
            }
            n2 += 19;
        }
        if (RAS.isEnabled(19, 29)) {
            RAS.trace(19, 29, this, "create8225StackTables", "leaving");
        }
    }

    static {
        deviceGifs = new String[]{"unknownHub.gif", "jdm8237.gif", "jdm8237Mod2.gif", "jdm8237Mod2.gif", "jdm8237Mod2.gif", "jdm8225.gif", "jdm8225.gif", "jdm8225.gif"};
    }
}

